/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.stream.Stream;
import org.apache.james.jmap.JMAPRoute;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerResponse;

public interface JMAPRoutes {
    public static final JMAPRoute.Action CORS_CONTROL = JMAPRoutes.corsHeaders((req, res) -> res.send());

    public Stream<JMAPRoute> routes();

    public static JMAPRoute.Action corsHeaders(JMAPRoute.Action action) {
        return (req, res) -> action.handleRequest(req, res.header((CharSequence)"Access-Control-Allow-Origin", (CharSequence)"*").header((CharSequence)"Access-Control-Allow-Methods", (CharSequence)"GET, POST, OPTIONS").header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)"Content-Type, Authorization, Accept").header((CharSequence)"Access-Control-Max-Age", (CharSequence)"86400"));
    }

    public static JMAPRoute.Action redirectTo(String location) {
        return (req, res) -> res.status(HttpResponseStatus.FOUND).header((CharSequence)"Location", (CharSequence)location).send();
    }

    default public Mono<Void> handleInternalError(HttpServerResponse response, Logger logger, Throwable e) {
        logger.error("Internal server error", e);
        return response.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send();
    }

    default public Mono<Void> handleBadRequest(HttpServerResponse response, Logger logger, Throwable e) {
        logger.warn("Invalid request received.", e);
        return response.status(HttpResponseStatus.BAD_REQUEST).send();
    }

    default public Mono<Void> handleAuthenticationFailure(HttpServerResponse response, Logger logger, Throwable e) {
        logger.warn("Unauthorized", e);
        return response.status(HttpResponseStatus.UNAUTHORIZED).send();
    }
}

