/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.utils.FullyQualifiedClassName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FullyQualifiedClassNameTest {
    FullyQualifiedClassNameTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(FullyQualifiedClassName.class).verify();
    }

    @Test
    void constructorShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> new FullyQualifiedClassName(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void constructorShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> new FullyQualifiedClassName("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void getNameShouldReturnSuppliedValue() {
        String name = "org.apache.MyClass";
        Assertions.assertThat((String)new FullyQualifiedClassName(name).getName()).isEqualTo(name);
    }

    @Test
    void getNameShouldReturnSuppliedValueWhenOnlyAClassName() {
        String name = "MyClass";
        Assertions.assertThat((String)new FullyQualifiedClassName(name).getName()).isEqualTo(name);
    }
}

