/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.FullyQualifiedClassName;
import org.apache.james.utils.PackageName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassNameTest {
    ClassNameTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(ClassName.class).verify();
    }

    @Test
    void constructorShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> new ClassName(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void constructorShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> new ClassName("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void constructorShouldThrowWhenStartWithDot() {
        Assertions.assertThatThrownBy(() -> new ClassName(".MyClass")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void constructorShouldThrowWhenEndWithDot() {
        Assertions.assertThatThrownBy(() -> new ClassName("MyClass.")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void constructorShouldThrowWhenEmptyPackagePart() {
        Assertions.assertThatThrownBy(() -> new ClassName("part..MyClass")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void getNameShouldReturnSuppliedValue() {
        String name = "org.apache.MyClass";
        Assertions.assertThat((String)new ClassName(name).getName()).isEqualTo(name);
    }

    @Test
    void getNameShouldReturnSuppliedValueWhenNoPackage() {
        String name = "MyClass";
        Assertions.assertThat((String)new ClassName(name).getName()).isEqualTo(name);
    }

    @Test
    void asFullyQualifiedShouldReturnCorrespondingFullyQualifiedClassName() {
        String name = "org.apache.MyClass";
        Assertions.assertThat((Object)new ClassName(name).asFullyQualified()).isEqualTo((Object)new FullyQualifiedClassName(name));
    }

    @Test
    void appendPackageShouldAddPackageInFullyQualifiedClassName() {
        String name = "MyClass";
        String packageName = "org.apache";
        Assertions.assertThat((Object)new ClassName(name).appendPackage(PackageName.of((String)packageName))).isEqualTo((Object)new FullyQualifiedClassName("org.apache.MyClass"));
    }

    @Test
    void appendPackageShouldAddPackageInFullyQualifiedClassNameWhenAPackagePartAlreadyExists() {
        String name = "part.MyClass";
        String packageName = "org.apache";
        Assertions.assertThat((Object)new ClassName(name).appendPackage(PackageName.of((String)packageName))).isEqualTo((Object)new FullyQualifiedClassName("org.apache.part.MyClass"));
    }
}

