/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.apache.james.adapter.mailbox.ACLUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.DelegationStoreAuthorizator;
import org.apache.james.adapter.mailbox.MailboxUserDeletionTaskStep;
import org.apache.james.adapter.mailbox.MailboxUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.QuotaUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.UserRepositoryAuthenticator;
import org.apache.james.events.EventListener;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.memory.change.MemoryEmailChangeRepository;
import org.apache.james.jmap.memory.change.MemoryMailboxChangeRepository;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.AttachmentIdFactory;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.StringBackedAttachmentIdFactory;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.mail.InMemoryModSeqProvider;
import org.apache.james.mailbox.inmemory.mail.InMemoryUidProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreAttachmentManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.event.MailboxSubscriptionListener;
import org.apache.james.mailbox.store.extractor.JsoupTextExtractor;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.SearchThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.modules.mailbox.DefaultEventModule;
import org.apache.james.modules.mailbox.MemoryDeadLetterModule;
import org.apache.james.modules.mailbox.MemoryQuotaModule;
import org.apache.james.modules.mailbox.MemoryQuotaSearchModule;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.utils.MailboxManagerDefinition;
import org.apache.james.vault.memory.metadata.MemoryDeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;

public class MemoryMailboxModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new DefaultEventModule());
        this.install((Module)new MemoryDeadLetterModule());
        this.install((Module)new MemoryQuotaModule());
        this.install((Module)new MemoryQuotaSearchModule());
        this.bind(MessageMapperFactory.class).to(InMemoryMailboxSessionMapperFactory.class);
        this.bind(MailboxMapperFactory.class).to(InMemoryMailboxSessionMapperFactory.class);
        this.bind(AttachmentIdFactory.class).to(StringBackedAttachmentIdFactory.class);
        this.bind(AttachmentMapperFactory.class).to(InMemoryMailboxSessionMapperFactory.class);
        this.bind(MailboxSessionMapperFactory.class).to(InMemoryMailboxSessionMapperFactory.class);
        this.bind(ModSeqProvider.class).to(InMemoryModSeqProvider.class);
        this.bind(UidProvider.class).to(InMemoryUidProvider.class);
        this.bind(MailboxId.Factory.class).to(InMemoryId.Factory.class);
        this.bind(MessageId.Factory.class).to(InMemoryMessageId.Factory.class);
        this.bind(ThreadIdGuessingAlgorithm.class).to(SearchThreadIdGuessingAlgorithm.class);
        this.bind(State.Factory.class).to(State.DefaultFactory.class);
        this.bind(SubscriptionManager.class).to(StoreSubscriptionManager.class);
        this.bind(SubscriptionMapperFactory.class).to(InMemoryMailboxSessionMapperFactory.class);
        this.bind(MailboxSessionMapperFactory.class).to(InMemoryMailboxSessionMapperFactory.class);
        this.bind(MailboxPathLocker.class).to(JVMMailboxPathLocker.class);
        this.bind(Authenticator.class).to(UserRepositoryAuthenticator.class);
        this.bind(Authorizator.class).to(DelegationStoreAuthorizator.class);
        this.bind(MailboxManager.class).to(InMemoryMailboxManager.class);
        this.bind(StoreMailboxManager.class).to(InMemoryMailboxManager.class);
        this.bind(MailboxChangeRepository.class).to(MemoryMailboxChangeRepository.class);
        this.bind(EmailChangeRepository.class).to(MemoryEmailChangeRepository.class);
        this.bind(MessageIdManager.class).to(StoreMessageIdManager.class);
        this.bind(AttachmentManager.class).to(StoreAttachmentManager.class);
        this.bind(SessionProvider.class).to(SessionProviderImpl.class);
        this.bind(MessageSearchIndex.class).to(SimpleMessageSearchIndex.class);
        this.bind(TextExtractor.class).to(JsoupTextExtractor.class);
        this.bind(RightManager.class).to(StoreRightManager.class);
        this.bind(AttachmentContentLoader.class).to(AttachmentManager.class);
        this.bind(DeletedMessageMetadataVault.class).to(MemoryDeletedMessageMetadataVault.class);
        this.bind(InMemoryMailboxSessionMapperFactory.class).in(Scopes.SINGLETON);
        this.bind(InMemoryModSeqProvider.class).in(Scopes.SINGLETON);
        this.bind(InMemoryUidProvider.class).in(Scopes.SINGLETON);
        this.bind(StoreSubscriptionManager.class).in(Scopes.SINGLETON);
        this.bind(JVMMailboxPathLocker.class).in(Scopes.SINGLETON);
        this.bind(UserRepositoryAuthenticator.class).in(Scopes.SINGLETON);
        this.bind(DelegationStoreAuthorizator.class).in(Scopes.SINGLETON);
        this.bind(InMemoryMailboxManager.class).in(Scopes.SINGLETON);
        this.bind(MemoryMailboxChangeRepository.class).in(Scopes.SINGLETON);
        this.bind(MemoryEmailChangeRepository.class).in(Scopes.SINGLETON);
        this.bind(InMemoryMessageId.Factory.class).in(Scopes.SINGLETON);
        this.bind(StoreMessageIdManager.class).in(Scopes.SINGLETON);
        this.bind(StoreAttachmentManager.class).in(Scopes.SINGLETON);
        this.bind(StoreRightManager.class).in(Scopes.SINGLETON);
        this.bind(MemoryDeletedMessageMetadataVault.class).in(Scopes.SINGLETON);
        this.bind(SessionProviderImpl.class).in(Scopes.SINGLETON);
        this.bind(Limit.class).annotatedWith((Annotation)Names.named((String)"emailChangeDefaultLimit")).toInstance((Object)Limit.of((int)256));
        this.bind(Limit.class).annotatedWith((Annotation)Names.named((String)"mailboxChangeDefaultLimit")).toInstance((Object)Limit.of((int)256));
        Multibinder.newSetBinder((Binder)this.binder(), MailboxManagerDefinition.class).addBinding().to(MemoryMailboxManagerDefinition.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxAnnotationListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxSubscriptionListener.class);
        this.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).to(MailboxManager.class);
        this.bind(MailboxManagerConfiguration.class).toInstance((Object)MailboxManagerConfiguration.DEFAULT);
        Multibinder usernameChangeTaskStepMultibinder = Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(MailboxUsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(ACLUsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(QuotaUsernameChangeTaskStep.class);
        Multibinder deleteUserDataTaskStepMultibinder = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskStepMultibinder.addBinding().to(MailboxUserDeletionTaskStep.class);
    }

    @Singleton
    private static class MemoryMailboxManagerDefinition
    extends MailboxManagerDefinition {
        @Inject
        private MemoryMailboxManagerDefinition(InMemoryMailboxManager manager) {
            super("memory-mailboxmanager", (MailboxManager)manager);
        }
    }
}

