/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.modules.mailbox.PreDeletionHookConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PreDeletionHookConfigurationTest {
    PreDeletionHookConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(PreDeletionHookConfiguration.class).verify();
    }

    @Test
    void fromShouldThrowWhenClassNameIsMissing() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        Assertions.assertThatThrownBy(() -> PreDeletionHookConfigurationTest.lambda$fromShouldThrowWhenClassNameIsMissing$0((HierarchicalConfiguration)configuration)).isInstanceOf(ConfigurationException.class);
    }

    @Test
    void fromShouldThrowWhenClassNameIsEmpty() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("class", (Object)"");
        Assertions.assertThatThrownBy(() -> PreDeletionHookConfigurationTest.lambda$fromShouldThrowWhenClassNameIsEmpty$1((HierarchicalConfiguration)configuration)).isInstanceOf(ConfigurationException.class);
    }

    @Test
    void fromShouldReturnValueWithCorrectClassName() throws ConfigurationException {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        String className = "a.class";
        configuration.addProperty("class", (Object)className);
        Assertions.assertThat((Object)PreDeletionHookConfiguration.from((HierarchicalConfiguration)configuration)).isEqualTo((Object)PreDeletionHookConfiguration.forClass((String)className));
    }

    private static /* synthetic */ void lambda$fromShouldThrowWhenClassNameIsEmpty$1(HierarchicalConfiguration configuration) throws Throwable {
        PreDeletionHookConfiguration.from((HierarchicalConfiguration)configuration);
    }

    private static /* synthetic */ void lambda$fromShouldThrowWhenClassNameIsMissing$0(HierarchicalConfiguration configuration) throws Throwable {
        PreDeletionHookConfiguration.from((HierarchicalConfiguration)configuration);
    }
}

