/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.MemoryEventDeadLetters;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.events.GenericGroup;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.modules.mailbox.ConfiguredListener;
import org.apache.james.modules.mailbox.ListenerConfiguration;
import org.apache.james.modules.mailbox.MailboxListenerFactory;
import org.apache.james.modules.mailbox.MailboxListenersLoaderImpl;
import org.apache.james.modules.mailbox.NoopMailboxListener;
import org.apache.james.modules.mailbox.ReactiveNoopMailboxListener;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.utils.ExtendedClassLoader;
import org.apache.james.utils.GuiceGenericLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MailboxListenersLoaderImplTest {
    private InVMEventBus eventBus;
    private MailboxListenersLoaderImpl testee;

    MailboxListenersLoaderImplTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.getFile(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new FileNotFoundException()});
        this.eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new RecordingMetricFactory()), EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION, (EventDeadLetters)new MemoryEventDeadLetters());
        GuiceGenericLoader genericLoader = GuiceGenericLoader.forTesting((ExtendedClassLoader)new ExtendedClassLoader(fileSystem));
        this.testee = new MailboxListenersLoaderImpl(new MailboxListenerFactory(genericLoader), (EventBus)this.eventBus, (Set)ImmutableSet.of(), (Set)ImmutableSet.of());
    }

    @Test
    void deserializeNoopMailboxListenerGroup() throws Exception {
        Assertions.assertThat((Object)Group.deserialize((String)"org.apache.james.modules.mailbox.NoopMailboxListener$NoopMailboxListenerGroup")).isEqualTo((Object)new NoopMailboxListener.NoopMailboxListenerGroup());
    }

    @Test
    void createListenerShouldThrowWhenClassCantBeLoaded() {
        ListenerConfiguration configuration = ListenerConfiguration.forClass((String)"MyUnknownClass");
        Assertions.assertThatThrownBy(() -> this.testee.createListener(configuration)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void createListenerShouldThrowWhenClassCantBeCastToMailboxListener() {
        ListenerConfiguration configuration = ListenerConfiguration.forClass((String)"java.lang.String");
        Assertions.assertThatThrownBy(() -> this.testee.createListener(configuration)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void createListenerShouldThrowWhenNotFullClassName() {
        ListenerConfiguration configuration = ListenerConfiguration.forClass((String)"NoopMailboxListener");
        Assertions.assertThatThrownBy(() -> this.testee.createListener(configuration)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void createListenerShouldReturnMailboxListenerWhenConfigurationIsGood() {
        ListenerConfiguration configuration = ListenerConfiguration.forClass((String)"org.apache.james.modules.mailbox.ReactiveNoopMailboxListener");
        Pair listener = this.testee.createListener(configuration);
        Assertions.assertThat((Object)((EventListener.ReactiveEventListener)listener.getRight())).isInstanceOf(ReactiveNoopMailboxListener.class);
    }

    @Test
    void configureShouldAddMailboxListenersWhenConfigurationIsGood() throws Exception {
        XMLConfiguration configuration = this.toConfigutation("<listeners><listener><class>org.apache.james.modules.mailbox.NoopMailboxListener</class></listener></listeners>");
        this.testee.configure((HierarchicalConfiguration)configuration);
        Assertions.assertThat((Collection)this.eventBus.registeredGroups()).containsExactly((Object[])new Group[]{NoopMailboxListener.GROUP});
    }

    @Test
    void configurationShouldBeOptional() throws Exception {
        XMLConfiguration configuration = this.toConfigutation("<listeners><listener><class>org.apache.james.modules.mailbox.ConfiguredListener</class></listener></listeners>");
        this.testee.configure((HierarchicalConfiguration)configuration);
        Assertions.assertThat((String)ConfiguredListener.value).isNull();
    }

    @Test
    void configurationShouldBeTakenIntoAccount() throws Exception {
        ConfiguredListener.value = "v1";
        XMLConfiguration configuration = this.toConfigutation("<listeners><listener><class>org.apache.james.modules.mailbox.ConfiguredListener</class><configuration><value>v2</value></configuration></listener></listeners>");
        this.testee.configure((HierarchicalConfiguration)configuration);
        Assertions.assertThat((String)ConfiguredListener.value).isEqualTo("v2");
    }

    @Test
    void customGroupCanBePassed() throws Exception {
        XMLConfiguration configuration = this.toConfigutation("<listeners><listener><class>org.apache.james.modules.mailbox.NoopMailboxListener</class><group>Avengers</group></listener></listeners>");
        this.testee.configure((HierarchicalConfiguration)configuration);
        Assertions.assertThat((Collection)this.eventBus.registeredGroups()).containsExactly((Object[])new Group[]{new GenericGroup("Avengers")});
    }

    @Test
    void aListenerCanBeRegisteredOnSeveralGroups() throws Exception {
        XMLConfiguration configuration = this.toConfigutation("<listeners><listener><class>org.apache.james.modules.mailbox.NoopMailboxListener</class><group>Avengers</group></listener><listener><class>org.apache.james.modules.mailbox.NoopMailboxListener</class><group>Fantastic 4</group></listener></listeners>");
        this.testee.configure((HierarchicalConfiguration)configuration);
        Assertions.assertThat((Collection)this.eventBus.registeredGroups()).containsExactlyInAnyOrder((Object[])new Group[]{new GenericGroup("Avengers"), new GenericGroup("Fantastic 4")});
    }

    private XMLConfiguration toConfigutation(String configurationString) throws ConfigurationException, IOException {
        return FileConfigurationProvider.getConfig((InputStream)new ByteArrayInputStream(configurationString.getBytes(StandardCharsets.UTF_8)));
    }
}

