/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import java.util.Optional;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.modules.mailbox.ListenerConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ListenerConfigurationTest {
    ListenerConfigurationTest() {
    }

    @Test
    void fromShouldThrowWhenClassIsNotInTheConfiguration() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        Assertions.assertThatThrownBy(() -> ListenerConfiguration.from((HierarchicalConfiguration)configuration)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void fromShouldThrowWhenClassIsEmpty() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("class", (Object)"");
        Assertions.assertThatThrownBy(() -> ListenerConfiguration.from((HierarchicalConfiguration)configuration)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void getClazzShouldReturnTheClassNameFromTheConfiguration() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        String expectedClazz = "MyClassName";
        configuration.addProperty("class", (Object)expectedClazz);
        ListenerConfiguration listenerConfiguration = ListenerConfiguration.from((HierarchicalConfiguration)configuration);
        Assertions.assertThat((String)listenerConfiguration.getClazz()).isEqualTo(expectedClazz);
    }

    @Test
    void isAsyncShouldReturnConfiguredValue() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("class", (Object)"MyClassName");
        configuration.addProperty("async", (Object)"false");
        ListenerConfiguration listenerConfiguration = ListenerConfiguration.from((HierarchicalConfiguration)configuration);
        Assertions.assertThat((Optional)listenerConfiguration.isAsync()).contains((Object)false);
    }

    @Test
    void getGroupShouldBeEmptyByDefault() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("class", (Object)"MyClassName");
        ListenerConfiguration listenerConfiguration = ListenerConfiguration.from((HierarchicalConfiguration)configuration);
        Assertions.assertThat((Optional)listenerConfiguration.getGroup()).isEmpty();
    }

    @Test
    void getGroupShouldContainsConfiguredValue() {
        String groupName = "Avengers";
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("class", (Object)"MyClassName");
        configuration.addProperty("group", (Object)groupName);
        ListenerConfiguration listenerConfiguration = ListenerConfiguration.from((HierarchicalConfiguration)configuration);
        Assertions.assertThat((Optional)listenerConfiguration.getGroup()).contains((Object)groupName);
    }
}

