/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.modules.server.JmxConfiguration;
import org.apache.james.util.Host;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmxConfigurationTest {
    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(JmxConfiguration.class).verify();
    }

    @Test
    void fromPropertiesShouldReturnDefaultWhenEmpty() {
        Assertions.assertThat((Object)JmxConfiguration.fromProperties((Configuration)new PropertiesConfiguration())).isEqualTo((Object)JmxConfiguration.DEFAULT_CONFIGURATION);
    }

    @Test
    void fromPropertiesShouldReturnConfiguredValues() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.read((Reader)new StringReader("jmx.address=172.0.0.5\njmx.port=889\n"));
        Assertions.assertThat((Object)JmxConfiguration.fromProperties((Configuration)configuration)).isEqualTo((Object)new JmxConfiguration(true, Optional.of(Host.from((String)"172.0.0.5", (int)889))));
    }

    @Test
    void fromPropertiesShouldReturnDisabledWhenConfiguredAsDisabled() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.read((Reader)new StringReader("jmx.enabled=false\n"));
        Assertions.assertThat((Object)JmxConfiguration.fromProperties((Configuration)configuration)).isEqualTo((Object)JmxConfiguration.DISABLED);
    }

    @Test
    void fromPropertiesShouldReturnDisabledWhenConfiguredAsDisabledWithHost() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.read((Reader)new StringReader("jmx.enabled=false\njmx.address=172.0.0.5\njmx.port=889\n"));
        Assertions.assertThat((Object)JmxConfiguration.fromProperties((Configuration)configuration)).isEqualTo((Object)JmxConfiguration.DISABLED);
    }
}

