/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.util.Port;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PortTest {
    PortTest() {
    }

    @Test
    void portShouldRespectBeanContract() {
        EqualsVerifier.forClass(Port.class).verify();
    }

    @Test
    void assertValidShouldThrowOnNegativePort() {
        Assertions.assertThatThrownBy(() -> Port.assertValid((int)-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void assertValidShouldThrowOnZeroPort() {
        Assertions.assertThatThrownBy(() -> Port.assertValid((int)0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void assertValidShouldAcceptOne() {
        Port.assertValid((int)1);
    }

    @Test
    void assertValidShouldAcceptMaxValue() {
        Port.assertValid((int)65535);
    }

    @Test
    void assertValidShouldThrowOnTooBigValue() {
        Assertions.assertThatThrownBy(() -> Port.assertValid((int)65536)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void isValidShouldReturnFalseWhenNegative() {
        Assertions.assertThat((boolean)Port.isValid((int)-1)).isFalse();
    }

    @Test
    void isValidShouldReturnFalseWhenZero() {
        Assertions.assertThat((boolean)Port.isValid((int)0)).isFalse();
    }

    @Test
    void isValidShouldReturnTrueWhenOne() {
        Assertions.assertThat((boolean)Port.isValid((int)1)).isTrue();
    }

    @Test
    void isValidShouldReturnTrueWhenMaxValue() {
        Assertions.assertThat((boolean)Port.isValid((int)65535)).isTrue();
    }

    @Test
    void isValidShouldReturnFalseWhenAboveMaxValue() {
        Assertions.assertThat((boolean)Port.isValid((int)65536)).isFalse();
    }

    @Test
    void generateValidUnprivilegedPortShouldReturnAValidPort() {
        Assertions.assertThat((int)Port.generateValidUnprivilegedPort()).isBetween(Integer.valueOf(1024), Integer.valueOf(65535));
    }
}

