/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.util.Host;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HostTest {
    private static final int DEFAULT_PORT = 154;

    HostTest() {
    }

    @Test
    void parseConfStringShouldParseConfWithIpAndPort() {
        int expectedPort = 44;
        String expectedIp = "142.145.254.111";
        String ipAndPort = expectedIp + ":44";
        Host actual = Host.parseConfString((String)ipAndPort);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new Host(expectedIp, expectedPort));
    }

    @Test
    void parseConfStringShouldParseConfWithHostanmeAndPort() {
        int expectedPort = 44;
        String host = "host";
        Host actual = Host.parseConfString((String)(host + ":" + expectedPort));
        Assertions.assertThat((Object)actual).isEqualTo((Object)new Host(host, expectedPort));
    }

    @Test
    void parseConfStringShouldParseConfWithHostOnlyWhenDefaultPortIsProvided() {
        String ipAndPort = "142.145.254.111";
        String expectedIp = "142.145.254.111";
        Host actual = Host.parseConfString((String)ipAndPort, (int)154);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new Host(expectedIp, 154));
    }

    @Test
    void parseConfStringShouldFailWhenConfigIsAnEmptyString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseConfString((String)""));
    }

    @Test
    void parseConfStringShouldFailWhenOnlyHostnameAndNoDefaultPort() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseConfString((String)"hostnameOnly"));
    }

    @Test
    void parseConfStringShouldFailWhenNegativePort() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseConfString((String)"host:-1"));
    }

    @Test
    void parseConfStringShouldFailWhenZeroPort() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseConfString((String)"host:0"));
    }

    @Test
    void parseConfStringShouldFailWhenTooHighPort() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseConfString((String)"host:65536"));
    }

    @Test
    void parseConfStringShouldFailWhenConfigIsANullString() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> Host.parseConfString(null));
    }

    @Test
    void parseConfStringShouldFailWhenConfigIsInvalid() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseConfString((String)"10.10.10.10:42:43"));
    }

    @Test
    void parseHostsShouldParseEmptyString() {
        Assertions.assertThat((List)Host.parseHosts((String)"")).isEmpty();
    }

    @Test
    void parseHostsShouldParseMonoHost() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200")).containsOnly((Object[])new Host[]{new Host("localhost", 9200)});
    }

    @Test
    void parseHostsShouldParseMultiHosts() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,server:9155")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("server", 9155)});
    }

    @Test
    void parseHostsShouldNotFailOnMultiComma() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,,server:9155")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("server", 9155)});
    }

    @Test
    void parseHostsShouldFailOnInvalidHost() {
        Assertions.assertThatThrownBy(() -> Host.parseHosts((String)"localhost:invalid,,server:9155")).isInstanceOf(NumberFormatException.class);
    }

    @Test
    void parseHostsShouldSwallowDuplicates() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,localhost:9200")).containsOnly((Object[])new Host[]{new Host("localhost", 9200)});
    }

    @Test
    void parseHostsShouldNotSwallowSameAddressDifferentPort() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,localhost:9155")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("localhost", 9155)});
    }

    @Test
    void parseHostsShouldNotSwallowSamePortDifferentAddress() {
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,abcd:9200")).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("abcd", 9200)});
    }

    @Test
    void parseHostsShouldHandleDefaultPort() {
        int defaultPort = 155;
        Assertions.assertThat((List)Host.parseHosts((String)"localhost:9200,abcd", (int)defaultPort)).containsOnly((Object[])new Host[]{new Host("localhost", 9200), new Host("abcd", 155)});
    }

    @Test
    void parseHostsShouldThrowOnAbsentPortWhenNoDefaultPort() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> Host.parseHosts((String)"localhost:9200,abcd"));
    }

    @Test
    void hostShouldRespectBeanContract() {
        EqualsVerifier.forClass(Host.class).verify();
    }
}

