/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.api;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Domain;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class DomainTest {
    DomainTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(Domain.class).withIgnoredFields(new String[]{"domainName"}).verify();
    }

    @Test
    void shouldBeCaseInsensitive() {
        Assertions.assertThat((Object)Domain.of((String)"Domain")).isEqualTo((Object)Domain.of((String)"domain"));
    }

    @ParameterizedTest
    @ValueSource(strings={"", "aab..ddd", "aab.cc.1com", "abc.abcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcd.com", "domain$bad.com", "domain/bad.com", "domain\\bad.com", "domain@bad.com", "domain@bad.com", "domain%bad.com", "#domain.com", "bad-.com", "bad_.com", "-bad.com", "bad_.com", "[domain.tld", "domain.tld]", "a[aaa]a", "[aaa]a", "a[aaa]", "[]"})
    void invalidDomains(String arg) {
        Assertions.assertThatThrownBy(() -> Domain.of((String)arg)).isInstanceOf(IllegalArgumentException.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"domain.tld", "do-main.tld", "do_main.tld", "ab.dc.de.fr", "123.456.789.a23", "acv.abcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabc.fr", "ab--cv.fr", "ab__cd.fr", "domain", "[domain]", "127.0.0.1"})
    void validDomains(String arg) {
        Assertions.assertThatCode(() -> Domain.of((String)arg)).doesNotThrowAnyException();
    }

    @Test
    void shouldRemoveBrackets() {
        Assertions.assertThat((Object)Domain.of((String)"[domain]")).isEqualTo((Object)Domain.of((String)"domain"));
    }

    @Test
    void shouldThrowOnNullArgument() {
        Assertions.assertThatThrownBy(() -> Domain.of(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void shouldAllow253LongDomain() {
        Assertions.assertThat((String)Domain.of((String)(StringUtils.repeat((String)"aaaaaaaaa.", (int)25) + "aaa")).asString()).hasSize(253);
    }

    @Test
    void shouldThrowWhenTooLong() {
        Assertions.assertThatThrownBy(() -> Domain.of((String)StringUtils.repeat((char)'a', (int)254))).isInstanceOf(IllegalArgumentException.class);
    }
}

