/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface QuotaUsageValueTest<T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> {
    public U usageInstance(long var1);

    public T limitInstance(long var1);

    public T unlimited();

    @Test
    default public void greaterThanShouldReturnFalseWhenUsageEqualToLimit() {
        Assertions.assertThat((boolean)this.usageInstance(1L).exceedLimit(this.limitInstance(1L))).isFalse();
    }

    @Test
    default public void greaterThanShouldReturnFalseWhenUsageSmallerThanLimit() {
        Assertions.assertThat((boolean)this.usageInstance(1L).exceedLimit(this.limitInstance(2L))).isFalse();
    }

    @Test
    default public void greaterThanShouldReturnTrueWhenUsageGreaterThanLimit() {
        Assertions.assertThat((boolean)this.usageInstance(2L).exceedLimit(this.limitInstance(1L))).isTrue();
    }

    @Test
    default public void greaterThanShouldReturnFalseWhenUsageIsLimitedAndLimitIsUnlimited() {
        Assertions.assertThat((boolean)this.usageInstance(1L).exceedLimit(this.unlimited())).isFalse();
    }

    @Test
    default public void addShouldReturnSumResult() {
        Assertions.assertThat((Object)this.usageInstance(12L).add(this.usageInstance(23L))).isEqualTo(this.usageInstance(35L));
    }
}

