/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.healthcheck;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.core.healthcheck.ResultStatus;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResultTest {
    private static final ComponentName COMPONENT_NAME = new ComponentName("component");

    ResultTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(Result.class).verify();
    }

    @Test
    void componentNameShouldBeKeptWhenHealthy() {
        Result result = Result.healthy((ComponentName)COMPONENT_NAME);
        Assertions.assertThat((Object)result.getComponentName()).isEqualTo((Object)COMPONENT_NAME);
    }

    @Test
    void componentNameShouldBeKeptWhenUnhealthy() {
        Result result = Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((Object)result.getComponentName()).isEqualTo((Object)COMPONENT_NAME);
    }

    @Test
    void componentNameShouldBeKeptWhenDegraded() {
        Result result = Result.degraded((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((Object)result.getComponentName()).isEqualTo((Object)COMPONENT_NAME);
    }

    @Test
    void statusShouldBeHealthyWhenHealthy() {
        Result result = Result.healthy((ComponentName)COMPONENT_NAME);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)ResultStatus.HEALTHY);
    }

    @Test
    void causeShouldBeEmptyWhenHealthy() {
        Result result = Result.healthy((ComponentName)COMPONENT_NAME);
        Assertions.assertThat((Optional)result.getCause()).isEmpty();
    }

    @Test
    void isHealthyShouldBeTrueWhenHealthy() {
        Result result = Result.healthy((ComponentName)COMPONENT_NAME);
        Assertions.assertThat((boolean)result.isHealthy()).isTrue();
    }

    @Test
    void isDegradedShouldBeFalseWhenHealthy() {
        Result result = Result.healthy((ComponentName)COMPONENT_NAME);
        Assertions.assertThat((boolean)result.isDegraded()).isFalse();
    }

    @Test
    void isUnhealthyShouldBeFalseWhenHealthy() {
        Result result = Result.healthy((ComponentName)COMPONENT_NAME);
        Assertions.assertThat((boolean)result.isUnHealthy()).isFalse();
    }

    @Test
    void statusShouldBeDegradedWhenDegraded() {
        Result result = Result.degraded((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)ResultStatus.DEGRADED);
    }

    @Test
    void degradedShouldThrowWhenNullCause() {
        Assertions.assertThatThrownBy(() -> Result.degraded((ComponentName)COMPONENT_NAME, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void causeShouldBeKeptWhenNotDegraded() {
        String cause = "cause";
        Result result = Result.degraded((ComponentName)COMPONENT_NAME, (String)cause);
        Assertions.assertThat((Optional)result.getCause()).contains((Object)cause);
    }

    @Test
    void isHealthyShouldBeFalseWhenDegraded() {
        Result result = Result.degraded((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((boolean)result.isHealthy()).isFalse();
    }

    @Test
    void isDegradedShouldBeFalseWhenDegraded() {
        Result result = Result.degraded((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((boolean)result.isDegraded()).isTrue();
    }

    @Test
    void isUnhealthyShouldBeTrueWhenDegraded() {
        Result result = Result.degraded((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((boolean)result.isUnHealthy()).isFalse();
    }

    @Test
    void statusShouldBeUnhealthyWhenUnhealthy() {
        Result result = Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)ResultStatus.UNHEALTHY);
    }

    @Test
    void causeShouldBeKeptWhenNotEmpty() {
        String cause = "cause";
        Result result = Result.unhealthy((ComponentName)COMPONENT_NAME, (String)cause);
        Assertions.assertThat((Optional)result.getCause()).contains((Object)cause);
    }

    @Test
    void isHealthyShouldBeFalseWhenUnhealthy() {
        Result result = Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((boolean)result.isHealthy()).isFalse();
    }

    @Test
    void isDegradedShouldBeFalseWhenUnhealthy() {
        Result result = Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((boolean)result.isDegraded()).isFalse();
    }

    @Test
    void isUnhealthyShouldBeTrueWhenUnhealthy() {
        Result result = Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"cause");
        Assertions.assertThat((boolean)result.isUnHealthy()).isTrue();
    }

    @Test
    void unhealthyShouldThrowWhenNullCause() {
        Assertions.assertThatThrownBy(() -> Result.unhealthy((ComponentName)COMPONENT_NAME, null)).isInstanceOf(NullPointerException.class);
    }
}

