/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.builder;

import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Properties;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.core.builder.MimeMessageWrapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MimeMessageWrapperTest {
    MimeMessageWrapperTest() {
    }

    @Test
    void saveChangesShouldPreserveMessageId() throws Exception {
        String messageId = "<5436@ab.com>";
        String messageText = "Message-ID: " + messageId + "\r\nSubject: test\r\n\r\nContent!";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(messageText.getBytes(StandardCharsets.UTF_8));
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)inputStream);
        MimeMessageWrapper mimeMessageWrapper = MimeMessageWrapper.wrap((MimeMessage)message);
        mimeMessageWrapper.saveChanges();
        Assertions.assertThat((String)mimeMessageWrapper.getMessageID()).isEqualTo(messageId);
    }

    @Test
    void wrapShouldPreserveBody() throws Exception {
        String messageAsText = "header1: <5436@ab.com>\r\nSubject: test\r\n\r\nContent!";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(messageAsText.getBytes(StandardCharsets.UTF_8));
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)inputStream);
        MimeMessageWrapper mimeMessageWrapper = MimeMessageWrapper.wrap((MimeMessage)message);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        mimeMessageWrapper.writeTo((OutputStream)outputStream);
        Assertions.assertThat((String)new String(outputStream.toByteArray(), StandardCharsets.UTF_8)).isEqualTo(messageAsText);
    }

    @Test
    void wrapShouldNotThrowWhenNoBody() throws Exception {
        MimeMessage originalMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        originalMessage.addHeader("header1", "value1");
        originalMessage.addHeader("header2", "value2");
        originalMessage.addHeader("header2", "value3");
        MimeMessageWrapper mimeMessageWrapper = MimeMessageWrapper.wrap((MimeMessage)originalMessage);
        Assertions.assertThat(Collections.list(mimeMessageWrapper.getAllHeaders())).extracting(javaxHeader -> new MimeMessageBuilder.Header(javaxHeader.getName(), javaxHeader.getValue())).contains((Object[])new MimeMessageBuilder.Header[]{new MimeMessageBuilder.Header("header1", "value1"), new MimeMessageBuilder.Header("header2", "value2"), new MimeMessageBuilder.Header("header2", "value3")});
    }
}

