/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.builder;

import jakarta.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.util.MimeMessageUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MimeMessageBuilderTest {
    MimeMessageBuilderTest() {
    }

    @Test
    void buildShouldPreserveMessageID() throws Exception {
        String messageID = "<abc@123>";
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().addHeader("Message-ID", messageID).build();
        Assertions.assertThat((String)mimeMessage.getMessageID()).isEqualTo(messageID);
    }

    @Test
    void buildShouldAllowMultiValuedHeader() throws Exception {
        String headerName = "header";
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().addHeader(headerName, "value1").addHeader(headerName, "value2").build();
        Assertions.assertThat((Object[])mimeMessage.getHeader(headerName)).hasSize(2);
    }

    @Test
    void buildShouldPreserveDate() throws Exception {
        String value = "Wed, 28 Mar 2018 17:02:25 +0200";
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().addHeader("Date", value).build();
        Assertions.assertThat((Object[])mimeMessage.getHeader("Date")).containsExactly((Object[])new String[]{value});
    }

    @Test
    void embeddedMessagesShouldBeSupported() throws Exception {
        MimeMessage embeddedMimeMessage = MimeMessageBuilder.mimeMessageBuilder().setSubject("A unicorn eat popcorn").setText("As studies demonstrated unicorns eats cereals.").build();
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setSubject("Internet is a strange place").setContent(MimeMessageBuilder.multipartBuilder().addBody(MimeMessageBuilder.bodyPartBuilder().data("The following embedded message is sooo funny!")).addBody(embeddedMimeMessage)).build();
        Assertions.assertThat((String)MimeMessageUtil.asString((MimeMessage)mimeMessage)).contains(new CharSequence[]{MimeMessageUtil.asString((MimeMessage)embeddedMimeMessage)});
    }

    @Test
    void buildShouldAllowToSpecifyMultipartSubtype() throws Exception {
        MimeMessage mimeMessage = MimeMessageBuilder.mimeMessageBuilder().setContent(MimeMessageBuilder.multipartBuilder().subType("alternative").addBody(MimeMessageBuilder.bodyPartBuilder().data("Body 1")).addBody(MimeMessageBuilder.bodyPartBuilder().data("Body 2"))).build();
        Assertions.assertThat((String)mimeMessage.getContentType()).startsWith((CharSequence)"multipart/alternative");
    }
}

