/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UsernameTest {
    UsernameTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(Username.class).withNonnullFields(new String[]{"localPart", "domainPart"}).verify();
    }

    @Test
    void fromShouldThrowOnEmptyLocalPart() {
        Assertions.assertThatThrownBy(() -> Username.from((String)"", Optional.empty())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowOnNullDomainPart() {
        Assertions.assertThatThrownBy(() -> Username.from(null, Optional.empty())).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldThrowOnLocalPartWithDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.from((String)"aa@bb", Optional.empty())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowOnEmptyDomain() {
        Assertions.assertThatThrownBy(() -> Username.from((String)"aa", Optional.of(""))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowWhenDomainContainsDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.from((String)"aa", Optional.of("bb@cc"))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromLocalPartWithDomainStringVersionShouldThrowOnNullLocalPart() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithDomain(null, (String)"domain")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromLocalPartWithDomainStringVersionShouldThrowOnEmptyLocalPart() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithDomain((String)"", (String)"domain")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromLocalPartWithDomainStringVersionShouldThrowOnLocalPartThatContainsDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithDomain((String)"aa@bb", (String)"domain")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromLocalPartWithDomainStringVersionShouldThrowOnNullDomainPart() {
        String domain = null;
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithDomain((String)"local", (String)domain)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromLocalPartWithDomainStringVersionShouldThrowOnEmptyDomainPart() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithDomain((String)"local", (String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromLocalPartWithDomainStringVersionShouldThrowOnDomainPartThatContainsDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithDomain((String)"local", (String)"aa@bb")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromLocalPartWithoutDomainShouldThrowOnEmpty() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithoutDomain((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromLocalPartWithoutDomainShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithoutDomain(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromLocalPartWithoutDomainShouldThrowOnUsernameThatContainsDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.fromLocalPartWithoutDomain((String)"aa@bb")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Username.of(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowOnEmpty() {
        Assertions.assertThatThrownBy(() -> Username.of((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldAllow255LongUsername() {
        String tail = "@a";
        Assertions.assertThat((String)Username.of((String)(StringUtils.repeat((char)'j', (int)(255 - tail.length())) + tail)).asString()).hasSize(255);
    }

    @Test
    void fromUsernameShouldThrowWhenTooLong() {
        String tail = "@a";
        Assertions.assertThatThrownBy(() -> Username.of((String)(StringUtils.repeat((char)'j', (int)(255 - tail.length() + 1)) + tail))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowWhenMultipleDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.of((String)"aa@aa@aa")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowWhenMultipleDomainDelimiterTogether() {
        Assertions.assertThatThrownBy(() -> Username.of((String)"aa@@aa")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowWhenEndsWithDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.of((String)"aa@")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowWhenStartsWithDomainDelimiter() {
        Assertions.assertThatThrownBy(() -> Username.of((String)"@aa")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldThrowWhenBlank() {
        Assertions.assertThatThrownBy(() -> Username.of((String)"  ")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromUsernameShouldParseUsernameWithDomain() {
        Assertions.assertThat((Object)Username.of((String)"aa@bb")).isEqualTo((Object)Username.from((String)"aa", Optional.of("bb")));
    }

    @Test
    void fromUsernameShouldParseUsernameWithDomainWithAnd() {
        Assertions.assertThat((Object)Username.of((String)"a&a@bb")).isEqualTo((Object)Username.from((String)"a&a", Optional.of("bb")));
    }

    @Test
    void fromUsernameShouldParseUsernameWithoutDomain() {
        Assertions.assertThat((Object)Username.of((String)"aa")).isEqualTo((Object)Username.from((String)"aa", Optional.empty()));
    }

    @Test
    void fromLocalPartWithDomainShouldReturnAValidUser() {
        Assertions.assertThat((Object)Username.fromLocalPartWithDomain((String)"aa", (String)"bb")).isEqualTo((Object)Username.from((String)"aa", Optional.of("bb")));
    }

    @Test
    void fromLocalPartWithoutDomainShouldReturnAValidUser() {
        Assertions.assertThat((Object)Username.fromLocalPartWithoutDomain((String)"aa")).isEqualTo((Object)Username.from((String)"aa", Optional.empty()));
    }

    @Test
    void hasDomainPartShouldReturnFalseWhenNoDomain() {
        Assertions.assertThat((boolean)Username.fromLocalPartWithoutDomain((String)"aa").hasDomainPart()).isFalse();
    }

    @Test
    void hasDomainPartShouldReturnTrueWhenHasADomain() {
        Assertions.assertThat((boolean)Username.fromLocalPartWithDomain((String)"aa", (String)"domain").hasDomainPart()).isTrue();
    }

    @Test
    void withDefaultDomainShouldAppendDefaultDomainWhenNone() {
        Assertions.assertThat((Object)Username.of((String)"user").withDefaultDomain(Domain.LOCALHOST)).isEqualTo((Object)Username.fromLocalPartWithDomain((String)"user", (Domain)Domain.LOCALHOST));
    }

    @Test
    void withDefaultDomainShouldNotAppendDefaultDomainWhenDomainIsPresent() {
        Assertions.assertThat((Object)Username.of((String)"user@domain").withDefaultDomain(Domain.LOCALHOST)).isEqualTo((Object)Username.of((String)"user@domain"));
    }

    @Test
    void withDefaultDomainShouldNotThrowUponEmptyDomain() {
        Assertions.assertThat((Object)Username.of((String)"user").withDefaultDomain(Optional.empty())).isEqualTo((Object)Username.of((String)"user"));
    }

    @Test
    void withDefaultDomainShouldNotThrowUponEmptyDomainWhenUsersHadADomain() {
        Assertions.assertThat((Object)Username.of((String)"user@domain").withDefaultDomain(Optional.empty())).isEqualTo((Object)Username.of((String)"user@domain"));
    }

    @Test
    void withDefaultDomainFromUserShouldPreserveUserWhenAlreadyHasADomain() {
        Assertions.assertThat((Object)Username.of((String)"user@domain").withDefaultDomainFromUser(Username.of((String)"bob@tld"))).isEqualTo((Object)Username.of((String)"user@domain"));
    }

    @Test
    void withDefaultDomainFromUserShouldAppendOtherUserDomainWhenNone() {
        Assertions.assertThat((Object)Username.of((String)"user").withDefaultDomainFromUser(Username.of((String)"bob@tld"))).isEqualTo((Object)Username.of((String)"user@tld"));
    }

    @Test
    void withDefaultDomainFromUserShouldNotThrowUponNoDomain() {
        Assertions.assertThat((Object)Username.of((String)"user").withDefaultDomainFromUser(Username.of((String)"bob"))).isEqualTo((Object)Username.of((String)"user"));
    }

    @Test
    void equalsShouldReturnFalseWhenDifferentId() {
        Assertions.assertThat((boolean)Username.of((String)"user").equals((Object)Username.of((String)"user2"))).isFalse();
    }

    @Test
    void equalsShouldReturnTrueWhenSameIdWithDifferentCase() {
        Assertions.assertThat((boolean)Username.of((String)"user").equals((Object)Username.of((String)"uSEr"))).isTrue();
    }
}

