/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import jakarta.mail.internet.AddressException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MaybeSenderTest {
    private static final String GOOD_ADDRESS = "server-dev@james.apache.org";
    private static final String MAIL_ADDRESS_STRING = "any@domain.tld";
    private MailAddress mailAddress;

    MaybeSenderTest() {
    }

    @BeforeEach
    void setUp() throws AddressException {
        this.mailAddress = new MailAddress(MAIL_ADDRESS_STRING);
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(MaybeSender.class).verify();
    }

    @Test
    void ofShouldSanitizeNull() {
        Assertions.assertThat((Object)MaybeSender.of(null)).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void ofShouldSanitizeNullSender() {
        Assertions.assertThat((Object)MaybeSender.of((MailAddress)MailAddress.nullSender())).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void asOptionalShouldReturnWrappedValue() {
        Assertions.assertThat((Optional)MaybeSender.of((MailAddress)this.mailAddress).asOptional()).contains((Object)this.mailAddress);
    }

    @Test
    void asOptionalShouldReturnEmptyWhenNullSender() {
        Assertions.assertThat((Optional)MaybeSender.nullSender().asOptional()).isEmpty();
    }

    @Test
    void getShouldReturnWrappedValue() {
        Assertions.assertThat((Object)MaybeSender.of((MailAddress)this.mailAddress).get()).isEqualTo((Object)this.mailAddress);
    }

    @Test
    void getShouldThrowWhenNullSender() {
        Assertions.assertThatThrownBy(() -> MaybeSender.nullSender().get()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void asListShouldReturnWrappedValue() {
        Assertions.assertThat((List)MaybeSender.of((MailAddress)this.mailAddress).asList()).contains((Object[])new MailAddress[]{this.mailAddress});
    }

    @Test
    void asListShouldReturnEmptyWhenNullSender() {
        Assertions.assertThat((List)MaybeSender.nullSender().asList()).isEmpty();
    }

    @Test
    void asStreamShouldReturnWrappedValue() {
        Assertions.assertThat((Stream)MaybeSender.of((MailAddress)this.mailAddress).asStream()).contains((Object[])new MailAddress[]{this.mailAddress});
    }

    @Test
    void asStreamShouldReturnEmptyWhenNullSender() {
        Assertions.assertThat((Stream)MaybeSender.nullSender().asStream()).isEmpty();
    }

    @Test
    void isNullSenderShouldReturnFalseWhenNotNullSender() {
        Assertions.assertThat((boolean)MaybeSender.of((MailAddress)this.mailAddress).isNullSender()).isFalse();
    }

    @Test
    void isNullSenderShouldReturnTrueWhenNullSender() {
        Assertions.assertThat((boolean)MaybeSender.nullSender().isNullSender()).isTrue();
    }

    @Test
    void asStringShouldReturnWrappedValue() {
        Assertions.assertThat((String)MaybeSender.of((MailAddress)this.mailAddress).asString()).isEqualTo(MAIL_ADDRESS_STRING);
    }

    @Test
    void asStringShouldReturnDefaultWhenNullSender() {
        Assertions.assertThat((String)MaybeSender.nullSender().asString()).isEqualTo("<>");
    }

    @Test
    void asStringWithDefaultShouldReturnWrappedValue() {
        Assertions.assertThat((String)MaybeSender.of((MailAddress)this.mailAddress).asString("default")).isEqualTo(MAIL_ADDRESS_STRING);
    }

    @Test
    void asPrettyStringShouldReturnDefaultWhenNullSender() {
        Assertions.assertThat((String)MaybeSender.nullSender().asPrettyString()).isEqualTo("<>");
    }

    @Test
    void asPrettyStringShouldReturnWrappedValue() {
        Assertions.assertThat((String)MaybeSender.of((MailAddress)this.mailAddress).asPrettyString()).isEqualTo("<any@domain.tld>");
    }

    @Test
    void asStringWithDefaultShouldReturnDefaultWhenNullSender() {
        Assertions.assertThat((String)MaybeSender.nullSender().asString("default")).isEqualTo("default");
    }

    @Test
    void getMailSenderShouldReturnNullSenderWhenNullSender() {
        Assertions.assertThat((Object)MaybeSender.getMailSender((String)"<>")).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void getMailSenderShouldReturnParsedAddressWhenNotNullAddress() throws Exception {
        Assertions.assertThat((Object)MaybeSender.getMailSender((String)GOOD_ADDRESS)).isEqualTo((Object)MaybeSender.of((MailAddress)new MailAddress(GOOD_ADDRESS)));
    }

    @Test
    void getMailSenderShouldReturnNullSenderWhenNull() {
        Assertions.assertThat((Object)MaybeSender.getMailSender(null)).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void getMailSenderShouldReturnNullSenderWhenEmptyString() {
        Assertions.assertThat((Object)MaybeSender.getMailSender((String)"")).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void getMailSenderShouldReturnNullSenderWhenOnlySpaces() {
        Assertions.assertThat((Object)MaybeSender.getMailSender((String)"   ")).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void getMailSenderShouldReturnNullSenderWhenBadValue() {
        Assertions.assertThat((Object)MaybeSender.getMailSender((String)"this@is@a@bad@address")).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void equalsShouldReturnFalseWhenOnlyFirstMemberIsANullSender() {
        Assertions.assertThat((Object)MaybeSender.getMailSender((String)GOOD_ADDRESS)).isNotEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void equalsShouldReturnFalseWhenOnlySecondMemberIsANullSender() {
        Assertions.assertThat((Object)MaybeSender.nullSender()).isNotEqualTo((Object)MaybeSender.getMailSender((String)GOOD_ADDRESS));
    }
}

