/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.Optional;
import java.util.stream.Stream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MailAddressTest {
    private static final String GOOD_LOCAL_PART = "\"quoted@local part\"";
    private static final String GOOD_QUOTED_LOCAL_PART = "\"quoted@local part\"@james.apache.org";
    private static final String GOOD_ADDRESS = "server-dev@james.apache.org";
    private static final Domain GOOD_DOMAIN = Domain.of((String)"james.apache.org");

    MailAddressTest() {
    }

    private static Stream<Arguments> goodAddresses() {
        return Stream.of(GOOD_ADDRESS, GOOD_QUOTED_LOCAL_PART, "server-dev@james-apache.org", "a&b@james-apache.org", "server-dev@[127.0.0.1]", "server.dev@james.apache.org", "\\.server-dev@james.apache.org", "Abc@10.42.0.1", "Abc.123@example.com", "user+mailbox/department=shipping@example.com", "user+mailbox@example.com", "\"Abc@def\"@example.com", "\"Fred Bloggs\"@example.com", "\"Joe.\\Blow\"@example.com", "!#$%&'*+-/=?^_`.{|}~@example.com").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> badAddresses() {
        return Stream.of("", "server-dev", "server-dev@", "[]", "server-dev@[]", "server-dev@#", "quoted local-part@james.apache.org", "quoted@local-part@james.apache.org", "local-part.@james.apache.org", ".local-part@james.apache.org", "local-part@.james.apache.org", "local-part@james.apache.org.", "local-part@james.apache..org", "server-dev@-james.apache.org", "server-dev@james.apache.org-", "server-dev@#james.apache.org", "server-dev@#123james.apache.org", "server-dev@#-123.james.apache.org", "server-dev@james. apache.org", "server-dev@james\\.apache.org", "server-dev@[300.0.0.1]", "server-dev@[127.0.1]", "server-dev@[0127.0.0.1]", "server-dev@[127.0.1.1a]", "server-dev@[127\\.0.1.1]", "server-dev@#123", "server-dev@#123.apache.org", "server-dev@[127.0.1.1.1]", "server-dev@[127.0.1.-1]", "\"a..b\"@domain.com", "server-dev\\.@james.apache.org", "a..b@domain.com", "Lo\u00efc.Accentu\u00e9@voil\u00e0.fr8", "pel\u00e9@exemple.com", "\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae@\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", "\u6211\u8cb7@\u5c4b\u4f01.\u9999\u6e2f", "\u4e8c\u30ce\u5bae@\u9ed2\u5ddd.\u65e5\u672c", "\u043c\u0435\u0434\u0432\u0435\u0434\u044c@\u0441-\u0431\u0430\u043b\u0430\u043b\u0430\u0439\u043a\u043e\u0439.\u0440\u0444", "\u0938\u0902\u092a\u0930\u094d\u0915@\u0921\u093e\u091f\u093e\u092e\u0947\u0932.\u092d\u093e\u0930\u0924", "mail.allow\\,d@james.apache.org").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"goodAddresses"})
    void testGoodMailAddressString(String mailAddress) {
        Assertions.assertThatCode(() -> new MailAddress(mailAddress)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @MethodSource(value={"goodAddresses"})
    void toInternetAddressShouldNoop(String mailAddress) throws Exception {
        Assertions.assertThat((Optional)new MailAddress(mailAddress).toInternetAddress()).isNotEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"badAddresses"})
    void testBadMailAddressString(String mailAddress) {
        Assertions.assertThatThrownBy(() -> new MailAddress(mailAddress)).isInstanceOf(AddressException.class);
    }

    @Test
    void testGoodMailAddressWithLocalPartAndDomain() {
        Assertions.assertThatCode(() -> new MailAddress("local-part", "domain")).doesNotThrowAnyException();
    }

    @Test
    void testBadMailAddressWithLocalPartAndDomain() {
        Assertions.assertThatThrownBy(() -> new MailAddress("local-part", "-domain")).isInstanceOf(AddressException.class);
    }

    @Test
    void testMailAddressInternetAddress() {
        Assertions.assertThatCode(() -> new MailAddress(new InternetAddress(GOOD_QUOTED_LOCAL_PART))).doesNotThrowAnyException();
    }

    @Test
    void testGetDomain() throws AddressException {
        MailAddress a = new MailAddress(new InternetAddress(GOOD_ADDRESS));
        Assertions.assertThat((Object)a.getDomain()).isEqualTo((Object)GOOD_DOMAIN);
    }

    @Test
    void testGetLocalPart() throws AddressException {
        MailAddress a = new MailAddress(new InternetAddress(GOOD_QUOTED_LOCAL_PART));
        Assertions.assertThat((String)a.getLocalPart()).isEqualTo(GOOD_LOCAL_PART);
    }

    @Test
    void testToString() throws AddressException {
        MailAddress a = new MailAddress(new InternetAddress(GOOD_ADDRESS));
        Assertions.assertThat((String)a.toString()).isEqualTo(GOOD_ADDRESS);
    }

    @Test
    void testToInternetAddress() throws AddressException {
        InternetAddress b = new InternetAddress(GOOD_ADDRESS);
        MailAddress a = new MailAddress(b);
        Assertions.assertThat((Optional)a.toInternetAddress()).contains((Object)b);
        Assertions.assertThat((String)a.toString()).isEqualTo(GOOD_ADDRESS);
    }

    @Test
    void testEqualsObject() throws AddressException {
        MailAddress a = new MailAddress(GOOD_ADDRESS);
        MailAddress b = new MailAddress(GOOD_ADDRESS);
        ((ObjectAssert)Assertions.assertThat((Object)a).isNotNull()).isEqualTo((Object)b);
    }

    @Test
    void equalsShouldReturnTrueWhenBothNullSender() {
        Assertions.assertThat((Object)MailAddress.nullSender()).isEqualTo((Object)MailAddress.nullSender());
    }

    @Test
    void getMailSenderShouldReturnNullSenderWhenNullSender() {
        Assertions.assertThat((Object)MailAddress.getMailSender((String)"<>")).isEqualTo((Object)MailAddress.nullSender());
    }

    @Test
    void getMailSenderShouldReturnParsedAddressWhenNotNullAddress() throws Exception {
        Assertions.assertThat((Object)MailAddress.getMailSender((String)GOOD_ADDRESS)).isEqualTo((Object)new MailAddress(GOOD_ADDRESS));
    }

    @Test
    void equalsShouldReturnFalseWhenOnlyFirstMemberIsANullSender() {
        Assertions.assertThat((Object)MailAddress.getMailSender((String)GOOD_ADDRESS)).isNotEqualTo((Object)MailAddress.nullSender());
    }

    @Test
    void equalsShouldReturnFalseWhenOnlySecondMemberIsANullSender() {
        Assertions.assertThat((Object)MailAddress.nullSender()).isNotEqualTo((Object)MailAddress.getMailSender((String)GOOD_ADDRESS));
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(MailAddress.class).verify();
    }
}

