/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.test.FakeMailContext;

public class FakeMailetConfig
implements MailetConfig {
    private final String mailetName;
    private final MailetContext mailetContext;
    private final Properties properties;

    public static Builder builder() {
        return new Builder();
    }

    private FakeMailetConfig(String mailetName, MailetContext mailetContext, Properties properties) {
        this.mailetName = mailetName;
        this.mailetContext = mailetContext;
        this.properties = properties;
    }

    public String getInitParameter(String name) {
        return this.properties.getProperty(name);
    }

    public Iterator<String> getInitParameterNames() {
        return this.properties.stringPropertyNames().iterator();
    }

    public MailetContext getMailetContext() {
        return this.mailetContext;
    }

    public String getMailetName() {
        return this.mailetName;
    }

    public static class Builder {
        private static final String DEFAULT_MAILET_NAME = "A Mailet";
        private Optional<String> mailetName = Optional.empty();
        private Optional<MailetContext> mailetContext = Optional.empty();
        private Properties properties = new Properties();

        private Builder() {
        }

        public Builder mailetName(String mailetName) {
            this.mailetName = Optional.ofNullable(mailetName);
            return this;
        }

        public Builder mailetContext(MailetContext mailetContext) {
            this.mailetContext = Optional.ofNullable(mailetContext);
            return this;
        }

        public Builder mailetContext(FakeMailContext.Builder mailetContext) {
            return this.mailetContext(mailetContext.build());
        }

        public Builder setProperty(String key, String value) {
            this.properties.setProperty(key, value);
            return this;
        }

        public FakeMailetConfig build() {
            return new FakeMailetConfig(this.mailetName.orElse(DEFAULT_MAILET_NAME), this.mailetContext.orElse(FakeMailContext.defaultContext()), this.properties);
        }
    }
}

