/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.healthcheck;

import jakarta.inject.Inject;
import java.time.Duration;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.rspamd.client.RspamdHttpClient;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class RspamdHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("Rspamd");
    private static final Duration HEALTH_CHECK_TIMEOUT = Duration.ofSeconds(5L);
    private final RspamdHttpClient rspamdHttpClient;

    @Inject
    public RspamdHealthCheck(RspamdHttpClient rspamdHttpClient) {
        this.rspamdHttpClient = rspamdHttpClient;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Publisher<Result> check() {
        return this.rspamdHttpClient.ping().timeout(HEALTH_CHECK_TIMEOUT).thenReturn((Object)Result.healthy((ComponentName)COMPONENT_NAME)).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Can not connect to Rspamd.", (Throwable)e)));
    }
}

