/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.SpamEventListener;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.rspamd.client.RspamdClientConfiguration;
import org.apache.james.rspamd.client.RspamdHttpClient;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RspamdListener
implements SpamEventListener,
EventListener.ReactiveGroupEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RspamdListener.class);
    private static final int LIMIT = 1;
    private static final Group GROUP = new RspamdListenerGroup();
    private final RspamdHttpClient rspamdHttpClient;
    private final RspamdClientConfiguration configuration;
    private final MailboxManager mailboxManager;
    private final MailboxSessionMapperFactory mapperFactory;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final RspamdListenerConfiguration rspamdListenerConfiguration;

    public RspamdListener(RspamdHttpClient rspamdHttpClient, MailboxManager mailboxManager, MailboxSessionMapperFactory mapperFactory, SystemMailboxesProvider systemMailboxesProvider, RspamdClientConfiguration configuration, RspamdListenerConfiguration rspamdListenerConfiguration) {
        this.rspamdHttpClient = rspamdHttpClient;
        this.configuration = configuration;
        this.mailboxManager = mailboxManager;
        this.mapperFactory = mapperFactory;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.rspamdListenerConfiguration = rspamdListenerConfiguration;
    }

    @Inject
    public RspamdListener(RspamdHttpClient rspamdHttpClient, MailboxManager mailboxManager, MailboxSessionMapperFactory mapperFactory, SystemMailboxesProvider systemMailboxesProvider, RspamdClientConfiguration configuration, HierarchicalConfiguration<ImmutableNode> rspamdListenerConfiguration) {
        this.rspamdHttpClient = rspamdHttpClient;
        this.configuration = configuration;
        this.mailboxManager = mailboxManager;
        this.mapperFactory = mapperFactory;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.rspamdListenerConfiguration = RspamdListenerConfiguration.from(rspamdListenerConfiguration);
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MessageMoveEvent || event instanceof MailboxEvents.Added;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MessageMoveEvent) {
            return this.handleMessageMoved((MessageMoveEvent)event);
        }
        if (this.rspamdListenerConfiguration.reportAdded && event instanceof MailboxEvents.Added) {
            return this.handleMessageAdded((MailboxEvents.Added)event);
        }
        return Mono.empty();
    }

    private Mono<Void> handleMessageAdded(MailboxEvents.Added addedEvent) {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)this.getClass().getCanonicalName()));
        return this.isAppendedToInbox(addedEvent).filter(FunctionalUtils.identityPredicate()).doOnNext(isHam -> LOGGER.debug("Ham event detected, EventId = {}", (Object)addedEvent.getEventId().getId())).flatMap(any -> this.reportHamWhenAdded(addedEvent, mailboxSession)).then(Mono.fromRunnable(() -> this.mailboxManager.endProcessingRequest(mailboxSession)));
    }

    private Mono<Void> handleMessageMoved(MessageMoveEvent messageMoveEvent) {
        return this.handleMessageMoved(this.mailboxMessagePublisher(messageMoveEvent), messageMoveEvent);
    }

    private Mono<Void> reportHamWhenAdded(MailboxEvents.Added addedEvent, MailboxSession session) {
        return this.mapperFactory.getMailboxMapper(session).findMailboxById(addedEvent.getMailboxId()).map(mailbox -> Pair.of((Object)mailbox, (Object)this.mapperFactory.getMessageMapper(session))).flatMapMany(pair -> Flux.fromIterable((Iterable)MessageRange.toRanges((Collection)addedEvent.getUids())).flatMap(range -> ((MessageMapper)pair.getRight()).findInMailboxReactive((Mailbox)pair.getLeft(), range, MessageMapper.FetchType.FULL, 1))).map(Message::getFullContentReactive).flatMap(content -> this.reportHam((Publisher<ByteBuffer>)content, (Event)addedEvent), 16).then();
    }

    private Flux<ByteBuffer> mailboxMessagePublisher(MessageMoveEvent messageMoveEvent) {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)this.getClass().getCanonicalName()));
        return Mono.fromCallable(() -> this.mapperFactory.getMessageIdMapper(mailboxSession)).flatMapMany(messageIdMapper -> messageIdMapper.findReactive(messageMoveEvent.getMessageIds(), MessageMapper.FetchType.FULL)).flatMap(Message::getFullContentReactive).doFinally(any -> this.mailboxManager.endProcessingRequest(mailboxSession));
    }

    private Mono<Void> handleMessageMoved(Flux<ByteBuffer> mailboxMessagesPublisher, MessageMoveEvent messageMoveEvent) {
        Mono reportHamIfNotSpamDetected = this.isMessageMovedOutOfSpamMailbox(messageMoveEvent).filter(FunctionalUtils.identityPredicate()).doOnNext(isHam -> LOGGER.debug("Ham event detected, EventId = {}", (Object)messageMoveEvent.getEventId().getId()));
        return this.isMessageMovedToSpamMailbox(messageMoveEvent).flatMap(isSpam -> {
            if (isSpam.booleanValue()) {
                LOGGER.debug("Spam event detected, EventId = {}", (Object)messageMoveEvent.getEventId().getId());
                return this.reportSpam(mailboxMessagesPublisher, messageMoveEvent).then();
            }
            return reportHamIfNotSpamDetected.flatMapMany(isHam -> this.reportHam((Publisher<ByteBuffer>)mailboxMessagesPublisher, (Event)messageMoveEvent)).then();
        });
    }

    private Mono<Void> reportHam(Publisher<ByteBuffer> content, Event messageMoveEvent) {
        if (this.configuration.usePerUserBayes()) {
            return this.rspamdHttpClient.reportAsHam(content, RspamdHttpClient.Options.forUser(messageMoveEvent.getUsername()));
        }
        return this.rspamdHttpClient.reportAsHam(content);
    }

    private Mono<Void> reportSpam(Flux<ByteBuffer> mailboxMessagesPublisher, MessageMoveEvent messageMoveEvent) {
        if (this.configuration.usePerUserBayes()) {
            return this.rspamdHttpClient.reportAsSpam((Publisher<ByteBuffer>)mailboxMessagesPublisher, RspamdHttpClient.Options.forUser(messageMoveEvent.getUsername()));
        }
        return this.rspamdHttpClient.reportAsSpam((Publisher<ByteBuffer>)mailboxMessagesPublisher);
    }

    @VisibleForTesting
    Mono<Boolean> isMessageMovedToSpamMailbox(MessageMoveEvent event) {
        return this.isMessageMovedToMailbox(event, Role.SPAM);
    }

    @VisibleForTesting
    Mono<Boolean> isMessageMovedOutOfSpamMailbox(MessageMoveEvent event) {
        return this.isMessageMovedOutToMailbox(event, Role.SPAM).zipWith(this.isMessageMovedToMailbox(event, Role.TRASH)).map(tuple -> (Boolean)tuple.getT1() != false && (Boolean)tuple.getT2() == false);
    }

    @VisibleForTesting
    Mono<Boolean> isAppendedToInbox(MailboxEvents.Added addedEvent) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(Role.INBOX, addedEvent.getUsername())).next().map(MessageManager::getId).map(mailboxId -> mailboxId.equals((Object)addedEvent.getMailboxId())).onErrorResume(e -> {
            LOGGER.warn("Could not resolve Inbox mailbox", e);
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> isMessageMovedToMailbox(MessageMoveEvent event, Role role) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(role, event.getUsername())).next().map(MessageManager::getId).map(spamMailboxId -> event.getMessageMoves().addedMailboxIds().contains(spamMailboxId)).onErrorResume(e -> {
            LOGGER.warn("Could not resolve {} mailbox", (Object)role, e);
            return Mono.just((Object)false);
        });
    }

    private Mono<Boolean> isMessageMovedOutToMailbox(MessageMoveEvent event, Role role) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(role, event.getUsername())).next().map(MessageManager::getId).map(spamMailboxId -> event.getMessageMoves().removedMailboxIds().contains(spamMailboxId)).onErrorResume(e -> {
            LOGGER.warn("Could not resolve {} mailbox", (Object)role, e);
            return Mono.just((Object)false);
        });
    }

    public static class RspamdListenerConfiguration {
        public static final RspamdListenerConfiguration DEFAULT = new RspamdListenerConfiguration(true);
        private final boolean reportAdded;

        public static RspamdListenerConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) {
            return new RspamdListenerConfiguration(configuration.getBoolean("reportAdded", true));
        }

        public RspamdListenerConfiguration(boolean reportAdded) {
            this.reportAdded = reportAdded;
        }
    }

    public static class RspamdListenerGroup
    extends Group {
    }
}

