/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransactionalMailboxMapper
implements MailboxMapper {
    private final JPAMailboxMapper wrapped;

    public TransactionalMailboxMapper(JPAMailboxMapper wrapped) {
        this.wrapped = wrapped;
    }

    public Mono<Mailbox> create(MailboxPath mailboxPath, UidValidity uidValidity) {
        return this.wrapped.executeReactive(this.wrapped.create(mailboxPath, uidValidity));
    }

    public Mono<MailboxId> rename(Mailbox mailbox) {
        return this.wrapped.executeReactive(this.wrapped.rename(mailbox));
    }

    public Mono<Void> delete(Mailbox mailbox) {
        return this.wrapped.executeReactive(this.wrapped.delete(mailbox));
    }

    public Mono<Mailbox> findMailboxByPath(MailboxPath mailboxPath) {
        return this.wrapped.findMailboxByPath(mailboxPath);
    }

    public Mono<Mailbox> findMailboxById(MailboxId mailboxId) {
        return this.wrapped.findMailboxById(mailboxId);
    }

    public Flux<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) {
        return this.wrapped.findMailboxWithPathLike(query);
    }

    public Mono<Boolean> hasChildren(Mailbox mailbox, char delimiter) {
        return this.wrapped.hasChildren(mailbox, delimiter);
    }

    public Mono<ACLDiff> updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) {
        return this.wrapped.updateACL(mailbox, mailboxACLCommand);
    }

    public Mono<ACLDiff> setACL(Mailbox mailbox, MailboxACL mailboxACL) {
        return this.wrapped.setACL(mailbox, mailboxACL);
    }

    public Flux<Mailbox> list() {
        return this.wrapped.list();
    }

    public Flux<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) {
        return this.wrapped.findNonPersonalMailboxes(userName, right);
    }
}

