/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.JPAAttachmentMapper;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import reactor.core.publisher.Mono;

public class TransactionalAttachmentMapper
implements AttachmentMapper {
    private final JPAAttachmentMapper attachmentMapper;

    public TransactionalAttachmentMapper(JPAAttachmentMapper attachmentMapper) {
        this.attachmentMapper = attachmentMapper;
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId) {
        return this.attachmentMapper.loadAttachmentContent(attachmentId);
    }

    public Mono<InputStream> loadAttachmentContentReactive(AttachmentId attachmentId) {
        return this.attachmentMapper.executeReactive(this.attachmentMapper.loadAttachmentContentReactive(attachmentId));
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        return this.attachmentMapper.getAttachment(attachmentId);
    }

    public Mono<AttachmentMetadata> getAttachmentReactive(AttachmentId attachmentId) {
        return this.attachmentMapper.executeReactive(this.attachmentMapper.getAttachmentReactive(attachmentId));
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        return this.attachmentMapper.getAttachments(attachmentIds);
    }

    public List<MessageAttachmentMetadata> storeAttachments(Collection<ParsedAttachment> attachments, MessageId ownerMessageId) throws MailboxException {
        return (List)this.attachmentMapper.execute(() -> this.attachmentMapper.storeAttachments(attachments, ownerMessageId));
    }

    public Mono<List<MessageAttachmentMetadata>> storeAttachmentsReactive(Collection<ParsedAttachment> attachments, MessageId ownerMessageId) {
        return this.attachmentMapper.executeReactive(this.attachmentMapper.storeAttachmentsReactive(attachments, ownerMessageId));
    }
}

