/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.mail.JPAMapperProvider;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.MapperProvider;
import org.apache.james.mailbox.store.mail.model.MessageAssert;
import org.apache.james.mailbox.store.mail.model.MessageWithAttachmentMapperTest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class JPAMessageWithAttachmentMapperTest
extends MessageWithAttachmentMapperTest {
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);

    JPAMessageWithAttachmentMapperTest() {
    }

    protected MapperProvider createMapperProvider() {
        return new JPAMapperProvider(JPA_TEST_CLUSTER);
    }

    @AfterEach
    void cleanUp() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }

    @Test
    protected void messagesRetrievedUsingFetchTypeFullShouldHaveAttachmentsLoadedWhenOneAttachment() throws MailboxException {
        this.saveMessages();
        MessageMapper.FetchType fetchType = MessageMapper.FetchType.FULL;
        Iterator retrievedMessageIterator = this.messageMapper.findInMailbox(this.attachmentsMailbox, MessageRange.one((MessageUid)this.messageWith1Attachment.getUid()), fetchType, 10);
        AttachmentMetadata attachment = ((MessageAttachmentMetadata)this.messageWith1Attachment.getAttachments().get(0)).getAttachment();
        MessageAttachmentMetadata attachmentMetadata = (MessageAttachmentMetadata)this.messageWith1Attachment.getAttachments().get(0);
        List messageAttachments = ((MailboxMessage)retrievedMessageIterator.next()).getAttachments();
        Assertions.assertThat((List)messageAttachments).extracting(MessageAttachmentMetadata::getAttachment).extracting(new String[]{"attachmentId", "size", "type"}).containsExactlyInAnyOrder((Object[])new Tuple[]{AssertionsForClassTypes.tuple((Object[])new Object[]{attachment.getAttachmentId(), attachment.getSize(), attachment.getType()})});
        Assertions.assertThat((List)messageAttachments).extracting(new Function[]{MessageAttachmentMetadata::getAttachmentId, MessageAttachmentMetadata::getName, MessageAttachmentMetadata::getCid, MessageAttachmentMetadata::isInline}).containsExactlyInAnyOrder((Object[])new Tuple[]{AssertionsForClassTypes.tuple((Object[])new Object[]{attachmentMetadata.getAttachmentId(), attachmentMetadata.getName(), attachmentMetadata.getCid(), attachmentMetadata.isInline()})});
    }

    @Test
    protected void messagesRetrievedUsingFetchTypeFullShouldHaveAttachmentsLoadedWhenTwoAttachments() throws MailboxException {
        this.saveMessages();
        MessageMapper.FetchType fetchType = MessageMapper.FetchType.FULL;
        Iterator retrievedMessageIterator = this.messageMapper.findInMailbox(this.attachmentsMailbox, MessageRange.one((MessageUid)this.messageWith2Attachments.getUid()), fetchType, 10);
        AttachmentMetadata attachment1 = ((MessageAttachmentMetadata)this.messageWith2Attachments.getAttachments().get(0)).getAttachment();
        AttachmentMetadata attachment2 = ((MessageAttachmentMetadata)this.messageWith2Attachments.getAttachments().get(1)).getAttachment();
        MessageAttachmentMetadata attachmentMetadata1 = (MessageAttachmentMetadata)this.messageWith2Attachments.getAttachments().get(0);
        MessageAttachmentMetadata attachmentMetadata2 = (MessageAttachmentMetadata)this.messageWith2Attachments.getAttachments().get(1);
        List messageAttachments = ((MailboxMessage)retrievedMessageIterator.next()).getAttachments();
        Assertions.assertThat((List)messageAttachments).extracting(MessageAttachmentMetadata::getAttachment).extracting(new String[]{"attachmentId", "size", "type"}).containsExactlyInAnyOrder((Object[])new Tuple[]{AssertionsForClassTypes.tuple((Object[])new Object[]{attachment1.getAttachmentId(), attachment1.getSize(), attachment1.getType()}), AssertionsForClassTypes.tuple((Object[])new Object[]{attachment2.getAttachmentId(), attachment2.getSize(), attachment2.getType()})});
        Assertions.assertThat((List)messageAttachments).extracting(new Function[]{MessageAttachmentMetadata::getAttachmentId, MessageAttachmentMetadata::getName, MessageAttachmentMetadata::getCid, MessageAttachmentMetadata::isInline}).containsExactlyInAnyOrder((Object[])new Tuple[]{AssertionsForClassTypes.tuple((Object[])new Object[]{attachmentMetadata1.getAttachmentId(), attachmentMetadata1.getName(), attachmentMetadata1.getCid(), attachmentMetadata1.isInline()}), AssertionsForClassTypes.tuple((Object[])new Object[]{attachmentMetadata2.getAttachmentId(), attachmentMetadata2.getName(), attachmentMetadata2.getCid(), attachmentMetadata2.isInline()})});
    }

    @Test
    protected void messagesCanBeRetrievedInMailboxWithRangeTypeOne() throws MailboxException, IOException {
        this.saveMessages();
        MessageMapper.FetchType fetchType = MessageMapper.FetchType.FULL;
        MessageAssert.assertThat((MailboxMessage)((MailboxMessage)this.messageMapper.findInMailbox(this.attachmentsMailbox, MessageRange.one((MessageUid)this.messageWith1Attachment.getUid()), fetchType, 10).next())).isEqualToWithoutAttachment((MailboxMessage)this.messageWith1Attachment, fetchType);
    }
}

