/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.mail.JPAAttachmentMapper;
import org.apache.james.mailbox.jpa.mail.TransactionalAttachmentMapper;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.model.AttachmentMapperTest;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class JPAAttachmentMapperTest
extends AttachmentMapperTest {
    private static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);

    JPAAttachmentMapperTest() {
    }

    @AfterEach
    void cleanUp() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }

    protected AttachmentMapper createAttachmentMapper() {
        return new TransactionalAttachmentMapper(new JPAAttachmentMapper(JPA_TEST_CLUSTER.getEntityManagerFactory()));
    }

    protected MessageId generateMessageId() {
        return new DefaultMessageId.Factory().generate();
    }

    @Test
    public void getAttachmentsShouldReturnTheAttachmentsWhenSome() throws Exception {
        ContentType content1 = ContentType.of((String)"content");
        byte[] bytes1 = "payload".getBytes(StandardCharsets.UTF_8);
        ContentType content2 = ContentType.of((String)"content");
        byte[] bytes2 = "payload".getBytes(StandardCharsets.UTF_8);
        MessageId messageId1 = this.generateMessageId();
        AttachmentMetadata stored1 = ((MessageAttachmentMetadata)this.attachmentMapper.storeAttachments((Collection)ImmutableList.of((Object)ParsedAttachment.builder().contentType(content1).content(ByteSource.wrap((byte[])bytes1)).noName().noCid().inline(false)), messageId1).get(0)).getAttachment();
        AttachmentMetadata stored2 = ((MessageAttachmentMetadata)this.attachmentMapper.storeAttachments((Collection)ImmutableList.of((Object)ParsedAttachment.builder().contentType(content2).content(ByteSource.wrap((byte[])bytes2)).noName().noCid().inline(false)), messageId1).get(0)).getAttachment();
        Assertions.assertThat((List)this.attachmentMapper.getAttachments((Collection)ImmutableList.of((Object)stored1.getAttachmentId(), (Object)stored2.getAttachmentId()))).extracting(new Function[]{AttachmentMetadata::getAttachmentId, AttachmentMetadata::getSize, AttachmentMetadata::getType}).contains((Object[])new Tuple[]{AssertionsForClassTypes.tuple((Object[])new Object[]{stored1.getAttachmentId(), stored1.getSize(), stored1.getType()}), AssertionsForClassTypes.tuple((Object[])new Object[]{stored2.getAttachmentId(), stored2.getSize(), stored2.getType()})});
    }
}

