/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import java.util.Optional;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxManagerStressContract;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.JpaMailboxManagerProvider;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMailboxManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

class JpaMailboxManagerStressTest
implements MailboxManagerStressContract<OpenJPAMailboxManager> {
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);
    Optional<OpenJPAMailboxManager> openJPAMailboxManager = Optional.empty();

    JpaMailboxManagerStressTest() {
    }

    public OpenJPAMailboxManager getManager() {
        return this.openJPAMailboxManager.get();
    }

    public EventBus retrieveEventBus() {
        return this.getManager().getEventBus();
    }

    @BeforeEach
    void setUp() {
        if (!this.openJPAMailboxManager.isPresent()) {
            this.openJPAMailboxManager = Optional.of(JpaMailboxManagerProvider.provideMailboxManager(JPA_TEST_CLUSTER));
        }
    }

    @AfterEach
    void tearDown() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }
}

