/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import jakarta.persistence.EntityManagerFactory;
import java.time.Clock;
import java.time.Instant;
import org.apache.james.backends.jpa.JPAConfiguration;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.MemoryEventDeadLetters;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.jpa.JPAAttachmentContentLoader;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMailboxManager;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.NaiveThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.utils.UpdatableTickingClock;

public class JpaMailboxManagerProvider {
    private static final int LIMIT_ANNOTATIONS = 3;
    private static final int LIMIT_ANNOTATION_SIZE = 30;

    public static OpenJPAMailboxManager provideMailboxManager(JpaTestCluster jpaTestCluster) {
        EntityManagerFactory entityManagerFactory = jpaTestCluster.getEntityManagerFactory();
        JPAConfiguration jpaConfiguration = JPAConfiguration.builder().driverName("driverName").driverURL("driverUrl").attachmentStorage(Boolean.valueOf(true)).build();
        JPAMailboxSessionMapperFactory mf = new JPAMailboxSessionMapperFactory(entityManagerFactory, new JPAUidProvider(entityManagerFactory), new JPAModSeqProvider(entityManagerFactory), jpaConfiguration);
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        MessageParser messageParser = new MessageParser();
        Authenticator noAuthenticator = null;
        Authorizator noAuthorizator = null;
        InVMEventBus eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new RecordingMetricFactory()), EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION, (EventDeadLetters)new MemoryEventDeadLetters());
        StoreRightManager storeRightManager = new StoreRightManager((MailboxSessionMapperFactory)mf, (MailboxACLResolver)aclResolver, (EventBus)eventBus);
        StoreMailboxAnnotationManager annotationManager = new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mf, storeRightManager, 3, 30);
        SessionProviderImpl sessionProvider = new SessionProviderImpl(noAuthenticator, noAuthorizator);
        QuotaComponents quotaComponents = QuotaComponents.disabled((SessionProvider)sessionProvider, (MailboxSessionMapperFactory)mf);
        SimpleMessageSearchIndex index = new SimpleMessageSearchIndex((MessageMapperFactory)mf, (MailboxMapperFactory)mf, (TextExtractor)new DefaultTextExtractor(), (AttachmentContentLoader)new JPAAttachmentContentLoader());
        return new OpenJPAMailboxManager(mf, (SessionProvider)sessionProvider, messageParser, (MessageId.Factory)new DefaultMessageId.Factory(), (EventBus)eventBus, annotationManager, storeRightManager, quotaComponents, (MessageSearchIndex)index, (ThreadIdGuessingAlgorithm)new NaiveThreadIdGuessingAlgorithm(), (Clock)new UpdatableTickingClock(Instant.now()));
    }
}

