/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import jakarta.persistence.EntityManagerFactory;
import org.apache.james.backends.jpa.JPAConfiguration;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.MemoryEventDeadLetters;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.SubscriptionManagerContract;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

class JPASubscriptionManagerTest
implements SubscriptionManagerContract {
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);
    SubscriptionManager subscriptionManager;

    JPASubscriptionManagerTest() {
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @BeforeEach
    void setUp() {
        EntityManagerFactory entityManagerFactory = JPA_TEST_CLUSTER.getEntityManagerFactory();
        JPAConfiguration jpaConfiguration = JPAConfiguration.builder().driverName("driverName").driverURL("driverUrl").build();
        JPAMailboxSessionMapperFactory mapperFactory = new JPAMailboxSessionMapperFactory(entityManagerFactory, new JPAUidProvider(entityManagerFactory), new JPAModSeqProvider(entityManagerFactory), jpaConfiguration);
        InVMEventBus eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new RecordingMetricFactory()), EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION, (EventDeadLetters)new MemoryEventDeadLetters());
        this.subscriptionManager = new StoreSubscriptionManager((SubscriptionMapperFactory)mapperFactory, (MailboxSessionMapperFactory)mapperFactory, (EventBus)eventBus);
    }

    @AfterEach
    void close() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }
}

