/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import java.util.Optional;
import org.apache.james.backends.jpa.JpaTestCluster;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxManagerTest;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.jpa.JPAMailboxFixture;
import org.apache.james.mailbox.jpa.JpaMailboxManagerProvider;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMailboxManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class JPAMailboxManagerTest
extends MailboxManagerTest<OpenJPAMailboxManager> {
    static final JpaTestCluster JPA_TEST_CLUSTER = JpaTestCluster.create(JPAMailboxFixture.MAILBOX_PERSISTANCE_CLASSES);
    Optional<OpenJPAMailboxManager> openJPAMailboxManager = Optional.empty();

    JPAMailboxManagerTest() {
    }

    protected OpenJPAMailboxManager provideMailboxManager() {
        if (!this.openJPAMailboxManager.isPresent()) {
            this.openJPAMailboxManager = Optional.of(JpaMailboxManagerProvider.provideMailboxManager(JPA_TEST_CLUSTER));
        }
        return this.openJPAMailboxManager.get();
    }

    protected SubscriptionManager provideSubscriptionManager() {
        return new StoreSubscriptionManager((SubscriptionMapperFactory)this.provideMailboxManager().getMapperFactory(), this.provideMailboxManager().getMapperFactory(), this.provideMailboxManager().getEventBus());
    }

    @AfterEach
    void tearDownJpa() {
        JPA_TEST_CLUSTER.clear(JPAMailboxFixture.MAILBOX_TABLE_NAMES);
    }

    @Disabled(value="MAILBOX-353 Creating concurrently mailboxes with the same parents with JPA")
    @Test
    public void creatingConcurrentlyMailboxesWithSameParentShouldNotFail() {
    }

    protected EventBus retrieveEventBus(OpenJPAMailboxManager mailboxManager) {
        return mailboxManager.getEventBus();
    }

    @Nested
    @Disabled(value="JPA does not support saveDate.")
    class SaveDateTests {
        SaveDateTests() {
        }
    }

    @Disabled(value="JPAMailboxManager is using DefaultMessageId which doesn't support full feature of a messageId, which is an essential element of the Vault")
    @Nested
    class HookTests {
        HookTests() {
        }
    }
}

