/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml;

import com.onelogin.AccountSettings;
import com.onelogin.saml.Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Response {
    private Document xmlDoc;
    private NodeList assertions;
    private Element rootElement;
    private final AccountSettings accountSettings;
    private final Certificate certificate;
    private String currentUrl;

    public Response(AccountSettings accountSettings) throws CertificateException {
        this.accountSettings = accountSettings;
        this.certificate = new Certificate();
        this.certificate.loadCertificate(this.accountSettings.getCertificate());
    }

    public void loadXml(String xml) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory fty = DocumentBuilderFactory.newInstance();
        fty.setNamespaceAware(true);
        fty.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = fty.newDocumentBuilder();
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        this.xmlDoc = builder.parse(bais);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//*[@ID]");
        NodeList nodeList = (NodeList)expr.evaluate(this.xmlDoc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elem = (Element)nodeList.item(i);
            Attr attr = (Attr)elem.getAttributes().getNamedItem("ID");
            elem.setIdAttributeNode(attr, true);
        }
    }

    public void loadXmlFromBase64(String response) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Base64 base64 = new Base64();
        byte[] decodedB = base64.decode(response);
        String decodedS = new String(decodedB);
        this.loadXml(decodedS);
    }

    public boolean isValid() throws Exception {
        this.rootElement = this.xmlDoc.getDocumentElement();
        this.assertions = this.xmlDoc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        this.xmlDoc.getDocumentElement().normalize();
        String attName = this.rootElement.getAttribute("Version");
        if (!attName.equals("2.0")) {
            throw new Exception("Unsupported SAML Version.");
        }
        attName = this.rootElement.getAttribute("ID");
        if (attName.equals("")) {
            throw new Exception("Missing ID attribute on SAML Response.");
        }
        if (this.assertions == null || this.assertions.getLength() != 1) {
            throw new Exception("SAML Response must contain 1 Assertion.");
        }
        NodeList nodes = this.xmlDoc.getElementsByTagNameNS("*", "Signature");
        if (nodes == null || nodes.getLength() == 0) {
            throw new Exception("Can't find signature in Document.");
        }
        String destinationUrl = this.rootElement.getAttribute("Destination");
        if (destinationUrl != null && !destinationUrl.equals(this.currentUrl)) {
            throw new Exception("The response was received at " + this.currentUrl + " instead of " + destinationUrl);
        }
        NodeList nodeAudience = this.xmlDoc.getElementsByTagNameNS("*", "Audience");
        String audienceUrl = nodeAudience.item(0).getChildNodes().item(0).getNodeValue();
        if (audienceUrl != null && !audienceUrl.equals(this.currentUrl)) {
            throw new Exception(audienceUrl + " is not a valid audience for this Response");
        }
        NodeList nodeSubConf = this.xmlDoc.getElementsByTagNameNS("*", "SubjectConfirmation");
        boolean validSubjectConfirmation = true;
        for (int i = 0; i < nodeSubConf.getLength(); ++i) {
            Node method = nodeSubConf.item(i).getAttributes().getNamedItem("Method");
            if (method != null && !method.getNodeValue().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer")) continue;
            NodeList childs = nodeSubConf.item(i).getChildNodes();
            for (int c = 0; c < childs.getLength(); ++c) {
                Calendar now;
                Calendar notBeforeDate;
                Node notBefore;
                Calendar now2;
                Calendar notOnOrAfterDate;
                Node notOnOrAfter;
                if (!childs.item(c).getLocalName().equals("SubjectConfirmationData")) continue;
                Node inResponseTo = childs.item(c).getAttributes().getNamedItem("InResponseTo");
                Node recipient = childs.item(c).getAttributes().getNamedItem("Recipient");
                if (recipient != null && !recipient.getNodeValue().equals(this.currentUrl)) {
                    validSubjectConfirmation = false;
                }
                if ((notOnOrAfter = childs.item(c).getAttributes().getNamedItem("NotOnOrAfter")) != null && (notOnOrAfterDate = DatatypeConverter.parseDateTime((String)notOnOrAfter.getNodeValue())).before(now2 = Calendar.getInstance(TimeZone.getTimeZone("UTC")))) {
                    validSubjectConfirmation = false;
                }
                if ((notBefore = childs.item(c).getAttributes().getNamedItem("NotBefore")) == null || !(notBeforeDate = DatatypeConverter.parseDateTime((String)notBefore.getNodeValue())).before(now = Calendar.getInstance(TimeZone.getTimeZone("UTC")))) continue;
                validSubjectConfirmation = false;
            }
        }
        if (!validSubjectConfirmation) {
            throw new Exception("A valid SubjectConfirmation was not found on this Response");
        }
        X509Certificate cert = this.certificate.getX509Cert();
        DOMValidateContext ctx = new DOMValidateContext(cert.getPublicKey(), nodes.item(0));
        XMLSignatureFactory sigF = XMLSignatureFactory.getInstance("DOM");
        XMLSignature xmlSignature = sigF.unmarshalXMLSignature(ctx);
        return xmlSignature.validate(ctx);
    }

    public String getNameId() throws Exception {
        NodeList nodes = this.xmlDoc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nodes.getLength() == 0) {
            throw new Exception("No name id found in Document.");
        }
        return nodes.item(0).getTextContent();
    }

    public String getAttribute(String name) {
        HashMap attributes = this.getAttributes();
        if (!attributes.isEmpty()) {
            return attributes.get(name).toString();
        }
        return null;
    }

    public HashMap getAttributes() {
        HashMap attributes = new HashMap();
        NodeList nodes = this.xmlDoc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
        if (nodes.getLength() != 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap attrName = nodes.item(i).getAttributes();
                String attName = attrName.getNamedItem("Name").getNodeValue();
                NodeList children = nodes.item(i).getChildNodes();
                ArrayList<String> attrValues = new ArrayList<String>();
                for (int j = 0; j < children.getLength(); ++j) {
                    attrValues.add(children.item(j).getTextContent());
                }
                attributes.put(attName, attrValues);
            }
        } else {
            return null;
        }
        return attributes;
    }

    private boolean setIdAttributeExists() {
        for (Method method : Element.class.getDeclaredMethods()) {
            if (!method.getName().equals("setIdAttribute")) continue;
            return true;
        }
        return false;
    }

    private void tagIdAttributes(Document xmlDoc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDestinationUrl(String urld) {
        this.currentUrl = urld;
    }
}

